 ; Bk - put a break line on the end of two lines.
 ; Copyright 1997, 2005, 2010 by Rocket Software Ltd.
 ; Calls Misps from the file misps.lsp.
 ; Toast - apparently you can eat it.
 (DEFUN C:BK (/ blips *error* pa pb pang dimsc dist pc p1 p2 p3 p4 p5 p6)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq osmo (getvar "osmode"))
  (setq blip (getvar "blipmode"))
  (setvar "blipmode" 0)
 ; Ŀ
 ;   Make an error handler.                                                
 ; 
  (defun *error* (shk)
   (setvar "osmode" osmo)
   (setvar "blipmode" blip)
   (command "undo" "end")
  (princ))
 ; Ŀ
 ;   Get two points.                                                       
 ; 
  (setq pa (getpoint "Point 1: "))
  (setq pb (getpoint pa "Point 2: "))
  (setq pang (angle pa pb))
  (setvar "osmode" 0)
 ; Ŀ
 ;   Set the grid size to 1/4 of the pa to pb distance with a maximum of   
 ;   2x dimscale.                                                          
 ; 
  (if (or (null wasp) (null misps))
      (load "misps"))
  (setq dimsc (misps))
  (setq dist (/ (setq pdis (distance pa pb)) 4))
  (if (> dist (setq dimsc2 (* 2 dimsc))) (setq dist dimsc2))
 ; Ŀ
 ;   Find various points.                                                  
 ; 
  (setq pc (polar pa pang (/ pdis 2)))       ; the break midpoint
  (setq p1 (polar pa (+ pang pi) dimsc))     ; outer line 1 outer endpoint
  (setq p2 (polar pc (+ pang pi) dist))      ; outer line 1 inner endpoint
  (setq p5 (polar pc pang dist))             ; outer line 2 inner endpoint
  (setq p6 (polar pb pang dimsc))            ; outer line 2 outer endpoint
  (setq p3 (polar (polar pc (+ pang (/ pi 2)) dist) (+ pang pi) (/ dist 2)))
  (setq p4 (polar (polar pc (- pang (/ pi 2)) dist) pang (/ dist 2)))
 ; Ŀ
 ;   Draw the polyline.                                                    
 ; 
  (command "pline" pa p1 p2 p3 p4 p5 p6 pb "")
 ; Ŀ
 ;   Clean up and end.                                                     
 ; 
  (*error* ())
 (princ))